﻿--[[	
	This table is used to determine that the recipe with item ID x teaches you the spell ID y
	[x] = y
	
	As of June 16, 2009, this table is based on information gathered by Ackis for ARL.
	source: AckisRecipeList\Datamine.lua, last updated Jan 27th, 2010
--]]

-------------------------------------------------------------------------------
-- Mined via Data-tools
-- Table is Public Domain now
-- Look up table of Spell IDs to the recipe which trains them.
-------------------------------------------------------------------------------
local SPELL_ITEM = {
	-------------------------------------------------------------------------------
	-- First Aid
	-------------------------------------------------------------------------------
	[7929] = 16112, 	[7935] = 6454, 		[10840] = 16113, 	[23787] = 19442, 
	[27032] = 21992, 	[27033] = 21993, 	[45546] = 39152, 

	-------------------------------------------------------------------------------
	-- Alchemy
	-------------------------------------------------------------------------------
	[2333] = 3396, 		[2335] = 2555, 		[3172] = 3393, 		[3174] = 3394, 
	[3175] = 3395, 		[3188] = 6211, 		[3230] = 2553, 		[3449] = 6068, 
	[3450] = 3830, 		[3451] = 3831, 		[3453] = 3832, 		[3454] = 14634, 
	[4508] = 4597, 		[4942] = 4624, 		[6617] = 5640, 		[6618] = 5643, 
	[6624] = 5642, 		[7255] = 6053, 		[7256] = 6054, 		[7257] = 6055, 
	[7258] = 6056, 		[7259] = 6057, 		[8240] = 6663, 		[11453] = 9293, 
	[11456] = 10644, 	[11458] = 9294, 	[11459] = 9303, 	[11464] = 9295, 
	[11466] = 9296, 	[11468] = 9297, 	[11472] = 9298, 	[11473] = 9302, 
	[11476] = 9301, 	[11477] = 9300, 	[11479] = 9304, 	[11480] = 9305, 
	[17187] = 12958, 	[17552] = 13476, 	[17553] = 13477, 	[17554] = 13478, 
	[17555] = 13479, 	[17556] = 13480, 	[17557] = 13481, 	[17559] = 13482, 
	[17560] = 13483, 	[17561] = 13484, 	[17562] = 13485, 	[17563] = 13486, 
	[17564] = 13487, 	[17565] = 13488, 	[17566] = 13489, 	[17570] = 13490, 
	[17571] = 13491, 	[17572] = 13492, 	[17573] = 13493, 	[17574] = 13494, 
	[17575] = 13495, 	[17576] = 13496, 	[17577] = 13497, 	[17578] = 13499, 
	[17580] = 13501, 	[17632] = 13517, 	[17634] = 13518, 	[17635] = 31354, 
	[17636] = 31356, 	[17637] = 31355, 	[17638] = 31357, 	[21923] = 17709, 
	[22732] = 18257, 	[24365] = 20011, 	[24366] = 20012, 	[24367] = 20013, 
	[24368] = 20014, 	[25146] = 20761, 	[26277] = 21547, 	[28543] = 22900, 
	[28546] = 22901, 	[28549] = 22902, 	[28550] = 22903, 	[28552] = 22904, 
	[28553] = 24001, 	[28554] = 22906, 	[28555] = 22907, 	[28556] = 22908, 
	[28557] = 22909, 	[28558] = 22910, 	[28562] = 22911, 	[28563] = 22912, 
	[28564] = 35295, 	[28565] = 22914, 	[28566] = 22915, 	[28567] = 22916, 
	[28568] = 30443, 	[28569] = 22918, 	[28570] = 22919, 	[28571] = 22920, 
	[28572] = 22921, 	[28573] = 22922, 	[28575] = 22923, 	[28576] = 22924, 
	[28577] = 22925, 	[28578] = 35294, 	[28579] = 22927, 	[29688] = 23574, 
	[32765] = 25869, 	[32766] = 29232, 	[38960] = 31680, 	[38961] = 31682, 
	[38962] = 31681, 	[39637] = 32070, 	[39639] = 32071, 	[42736] = 33209, 
	[47046] = 35752, 	[47048] = 35753, 	[47049] = 35754, 	[47050] = 35755, 
	[53936] = 44564, 	[53937] = 44566, 	[53938] = 44568, 	[53939] = 44565, 
	[53942] = 44567, 

	-------------------------------------------------------------------------------
	-- Blacksmithing
	-------------------------------------------------------------------------------
	[2667] = 2881, 		[2673] = 5578, 		[3295] = 2883, 		[3297] = 3608, 
	[3321] = 3609, 		[3325] = 3610, 		[3330] = 2882, 		[3334] = 3611, 
	[3336] = 3612, 		[3492] = 12162, 	[3493] = 3866, 		[3494] = 10858, 
	[3495] = 3867, 		[3496] = 12163, 	[3497] = 3868, 		[3498] = 12164, 
	[3500] = 3869, 		[3503] = 6047, 		[3504] = 3870, 		[3505] = 3871, 
	[3507] = 3872, 		[3511] = 3873, 		[3513] = 3874, 		[3515] = 3875, 
	[6518] = 5543, 		[7221] = 6044, 		[7222] = 6045, 		[7224] = 6046, 
	[8367] = 6735, 		[9811] = 7978, 		[9813] = 7979, 		[9814] = 7980, 
	[9818] = 7981, 		[9820] = 7982, 		[9933] = 7975, 		[9937] = 7995, 
	[9939] = 7976, 		[9945] = 7983, 		[9950] = 7984, 		[9952] = 7985, 
	[9964] = 7989, 		[9966] = 7991, 		[9970] = 7990, 		[9995] = 7992, 
	[9997] = 8029, 		[10005] = 7993, 	[10009] = 8028,		[10013] = 8030, 
	[11454] = 10713, 	[11643] = 9367, 	[12259] = 10424, 	[15292] = 11610, 
	[15293] = 11614, 	[15294] = 11611, 	[15295] = 11615, 	[15296] = 11612, 
	[15973] = 12261, 	[16642] = 12682, 	[16643] = 12683, 	[16644] = 12684, 
	[16645] = 12685, 	[16646] = 12687, 	[16647] = 12688, 	[16648] = 12689, 
	[16649] = 12690, 	[16650] = 12691, 	[16651] = 12692, 	[16652] = 12693, 
	[16653] = 12694, 	[16654] = 12695, 	[16655] = 12699, 	[16656] = 12697, 
	[16657] = 12700, 	[16658] = 12701, 	[16659] = 12702, 	[16660] = 12698, 
	[16661] = 12703, 	[16662] = 12704, 	[16663] = 12705, 	[16664] = 12706, 
	[16665] = 12707, 	[16667] = 12696, 	[16724] = 12711, 	[16725] = 12713, 
	[16726] = 12714, 	[16728] = 12716, 	[16729] = 12717, 	[16730] = 12715, 
	[16731] = 12718, 	[16732] = 12719, 	[16741] = 12720, 	[16742] = 12725, 
	[16744] = 12726, 	[16745] = 12727, 	[16746] = 12728, 	[16969] = 12819, 
	[16970] = 12821, 	[16971] = 12823, 	[16973] = 12824, 	[16978] = 12825, 
	[16983] = 12827, 	[16984] = 12828, 	[16985] = 12830, 	[16988] = 12833, 
	[16990] = 12834, 	[16991] = 12835, 	[16992] = 12836, 	[16993] = 12837, 
	[16994] = 12838, 	[16995] = 12839, 	[20872] = 17049, 	[20873] = 17053, 
	[20874] = 17051, 	[20876] = 17052, 	[20890] = 17059, 	[20897] = 17060, 
	[21161] = 18592, 	[21913] = 17706, 	[22757] = 18264, 	[23628] = 19202, 
	[23629] = 19204, 	[23632] = 19203, 	[23633] = 19205, 	[23636] = 19206, 
	[23637] = 19207, 	[23638] = 19208, 	[23639] = 19209, 	[23650] = 19210, 
	[23652] = 19211, 	[23653] = 19212, 	[24136] = 19776, 	[24137] = 19777, 
	[24138] = 19778, 	[24139] = 19779, 	[24140] = 19780, 	[24141] = 19781, 
	[24399] = 20040, 	[24912] = 20553, 	[24913] = 20555, 	[24914] = 20554, 
	[27585] = 22209, 	[27586] = 22219, 	[27587] = 22222, 	[27588] = 22214, 
	[27589] = 22220, 	[27590] = 22221, 	[27829] = 22388, 	[27830] = 22390, 
	[27832] = 22389, 	[28461] = 22766, 	[28462] = 22767, 	[28463] = 22768, 
	[29566] = 23590, 	[29568] = 23591, 	[29569] = 23592, 	[29571] = 23593, 
	[29603] = 23594, 	[29605] = 23595, 	[29606] = 23596, 	[29608] = 23597, 
	[29610] = 23599, 	[29611] = 23598, 	[29613] = 23600, 	[29614] = 23601, 
	[29615] = 23602, 	[29616] = 23603, 	[29617] = 23604, 	[29619] = 23605, 
	[29620] = 23606, 	[29621] = 23607, 	[29622] = 23621, 	[29628] = 23608, 
	[29629] = 23609, 	[29630] = 23610, 	[29642] = 23611, 	[29643] = 23612, 
	[29645] = 23613, 	[29648] = 23615, 	[29649] = 23617, 	[29656] = 23618, 
	[29657] = 24002, 	[29658] = 23620, 	[29662] = 23622, 	[29663] = 23623, 
	[29664] = 23624, 	[29668] = 23625, 	[29669] = 23626, 	[29671] = 23627, 
	[29672] = 23628, 	[29692] = 23629, 	[29693] = 23630, 	[29694] = 23631, 
	[29695] = 23632, 	[29696] = 23633, 	[29697] = 23634, 	[29698] = 23635, 
	[29699] = 23636, 	[29700] = 23637, 	[29728] = 23638, 	[29729] = 23639, 
	[32285] = 25526, 	[32656] = 25846, 	[32657] = 25847, 	[34608] = 28632, 
	[36389] = 30321, 	[36390] = 30322, 	[36391] = 30323, 	[36392] = 30324, 
	[38473] = 31390, 	[38475] = 31391, 	[38476] = 31392, 	[38477] = 31393, 
	[38478] = 31394, 	[38479] = 31395, 	[40033] = 32441, 	[40034] = 32442, 
	[40035] = 32443, 	[40036] = 32444, 	[41132] = 32736, 	[41133] = 32737, 
	[41134] = 32738, 	[41135] = 32739, 	[42688] = 35296, 	[43549] = 33792, 
	[43846] = 33954, 	[46140] = 35208, 	[46141] = 35209, 	[46142] = 35210, 
	[46144] = 35211, 	[54978] = 41124, 	[54979] = 41123, 	[54980] = 41120, 
	[54981] = 41122, 	[62202] = 44938, 	[63187] = 45088, 	[63188] = 45089, 
	[63189] = 45090, 	[63190] = 45091, 	[63191] = 45092, 	[63192] = 45093, 
	[67091] = 47622, 	[67130] = 47460, 	[67092] = 47623, 	[67131] = 47641, 
	[67096] = 47627, 	[67135] = 47642, 	[67095] = 47626, 	[67134] = 47643, 
	[67093] = 47624, 	[67132] = 47644, 	[67094] = 47625, 	[67133] = 47645, 

	-------------------------------------------------------------------------------
	-- Cooking
	-------------------------------------------------------------------------------
	[2542] = 2697, 		[2543] = 728, 		[2545] = 2698, 		[2547] = 2699, 
	[2548] = 2700, 		[2549] = 2701, 		[2795] = 2889, 		[3370] = 3678, 
	[3371] = 3679, 		[3372] = 3680, 		[3373] = 3681, 		[3376] = 3682, 
	[3377] = 3683, 		[3397] = 3734, 		[3398] = 3735, 		[3399] = 3736, 
	[3400] = 3737, 		[4094] = 4609, 		[6412] = 5482, 		[6413] = 5483, 
	[6414] = 5484, 		[6415] = 5485, 		[6416] = 5486, 		[6417] = 44977, 
	[6418] = 5488, 		[6419] = 5489, 		[6501] = 5528, 		[7213] = 6039, 
	[7751] = 6325, 		[7752] = 6326, 		[7753] = 6328, 		[7754] = 6329, 
	[7755] = 6330, 		[7827] = 6368, 		[7828] = 6369, 		[8238] = 6661, 
	[8607] = 6892, 		[9513] = 18160, 	[15853] = 12227, 	[15855] = 12228, 
	[15856] = 12229, 	[15861] = 12231, 	[15863] = 12232, 	[15865] = 12233, 
	[15906] = 12239, 	[15910] = 12240, 	[15915] = 16111, 	[15933] = 16110, 
	[15935] = 12226, 	[18238] = 13939, 	[18239] = 13940, 	[18240] = 13942, 
	[18241] = 13941, 	[18242] = 13943, 	[18243] = 13945, 	[18244] = 13946, 
	[18245] = 13947, 	[18246] = 13948, 	[18247] = 13949, 	[20626] = 16767, 
	[20916] = 17062, 	[21143] = 17200, 	[21144] = 17201, 	[22480] = 18046, 
	[22761] = 18267, 	[24418] = 20075, 	[25659] = 21025, 	[25704] = 21099, 
	[25954] = 21219, 	[28267] = 22647, 	[33276] = 27685, 	[33277] = 27686, 
	[33278] = 27687, 	[33279] = 27684, 	[33284] = 27688, 	[33285] = 27689, 
	[33286] = 27690, 	[33287] = 27691, 	[33288] = 27692, 	[33289] = 27693, 
	[33290] = 27694, 	[33291] = 27695, 	[33292] = 27696, 	[33293] = 27697, 
	[33294] = 27698, 	[33295] = 27699, 	[33296] = 27700, 	[36210] = 30156, 
	[38867] = 31675, 	[38868] = 31674, 	[43707] = 33870, 	[43758] = 33871, 
	[43761] = 33869, 	[43765] = 33873, 	[43772] = 33875, 	[43779] = 33925, 
	[45022] = 34413, 	[45555] = 43018, 	[45556] = 43019, 	[45557] = 43020, 
	[45558] = 43021, 	[45559] = 43022, 	[45567] = 43023, 	[45568] = 43024, 
	[45570] = 43026, 	[45571] = 43025, 	[45695] = 34834, 	[46684] = 35564, 
	[46688] = 35566, 	[53056] = 39644, 	[57423] = 43017, 	[57433] = 43027, 
	[57434] = 43028, 	[57435] = 43029, 	[57436] = 43030, 	[57437] = 43031, 
	[57438] = 43032, 	[57439] = 43033, 	[57440] = 43034, 	[57441] = 43035, 
	[57442] = 43036, 	[57443] = 43037, 	[58512] = 43507, 	[58521] = 43508, 
	[58523] = 43509, 	[58525] = 43510, 	[58527] = 43505, 	[58528] = 43506, 
	[62350] = 44954, 

	-------------------------------------------------------------------------------
	-- Enchanting
	-------------------------------------------------------------------------------
	[7443] = 6342, 		[7766] = 6344, 		[7776] = 6346, 		[7782] = 6347, 
	[7786] = 6348, 		[7793] = 6349, 		[7859] = 6375, 		[7867] = 6377, 
	[13380] = 11038, 	[13419] = 11039, 	[13464] = 11081, 	[13522] = 11098, 
	[13536] = 11101, 	[13612] = 11150, 	[13617] = 11151, 	[13620] = 11152, 
	[13646] = 11163, 	[13653] = 11164, 	[13655] = 11165, 	[13687] = 11167, 
	[13689] = 11168, 	[13698] = 11166, 	[13817] = 11202, 	[13841] = 11203, 
	[13846] = 11204, 	[13868] = 11205, 	[13882] = 11206, 	[13898] = 11207, 
	[13915] = 11208, 	[13931] = 11223, 	[13933] = 11224, 	[13945] = 11225, 
	[13947] = 11226, 	[15596] = 11813, 	[15596] = 45050, 
	[20009] = 16218, 	[20010] = 16246, 	[20011] = 16251, 	[20012] = 16219, 
 	[20014] = 16216, 	[20015] = 16224, 	[20016] = 16222, 
	[20017] = 16217, 	[20020] = 16215, 	[20023] = 16245, 	[20024] = 16220, 
	[20025] = 16253, 	[20026] = 16221, 	[20028] = 16242, 	[20029] = 16223, 
	[20030] = 16247, 	[20031] = 16250, 	[20032] = 16254, 	[20033] = 16248, 
	[20034] = 16252, 	[20035] = 16255, 	[20036] = 16249, 	[20051] = 16243, 
	[21931] = 17725, 	[22749] = 18259, 	[22750] = 18260, 	[23799] = 19444, 
	[23800] = 19445, 	[23801] = 19446, 	[23802] = 19447, 	[23803] = 19448, 
	[23804] = 19449, 	[25072] = 33153, 	[25072] = 20726, 	[25073] = 20727, 
	[25074] = 20728, 	[25078] = 20729, 	[25079] = 20730, 	[25080] = 33152, 
	[25080] = 20731, 	[25081] = 20732, 	[25082] = 20733, 	[25083] = 33149, 
	[25083] = 20734, 	[25084] = 20735, 	[25084] = 33150, 	[25084] = 33151, 
	[25086] = 20736, 	[25086] = 33148, 	[25124] = 20758, 	[25125] = 20752, 
	[25126] = 20753, 	[25127] = 20754, 	[25128] = 20755, 	[25129] = 20756, 
	[25130] = 20757, 	[27837] = 22392, 	[27906] = 22530, 	[27911] = 22531, 
	[27911] = 24000, 	[27913] = 22532, 	[27914] = 22533, 	[27917] = 22534, 
	[27920] = 22535, 	[27924] = 22536, 	[27926] = 22537, 	[27927] = 22538, 
	[27945] = 22539, 	[27946] = 22540, 	[27947] = 22541, 	[27948] = 35298, 
	[27948] = 22542, 	[27950] = 22543, 	[27951] = 22544, 	[27954] = 22545, 
	[27960] = 24003, 	[27960] = 22547, 	[27962] = 22548, 	[27967] = 22552, 
	[27968] = 22551, 	[27971] = 22554, 	[27972] = 22553, 	[27975] = 22555, 
	[27977] = 22556, 	[27981] = 22560, 	[27982] = 22561, 	[27984] = 22559, 
	[28003] = 22558, 	[28004] = 22557, 	[28016] = 22562, 	[28019] = 22563, 
	[28022] = 22565, 	[32665] = 25848, 	[32667] = 25849, 	[33992] = 28270, 
	[33994] = 28271, 	[33997] = 28272, 	[33999] = 28273, 	[34003] = 28274, 
	[34005] = 28276, 	[34006] = 28277, 	[34007] = 35299, 	[34007] = 28279, 
	[34008] = 35297, 	[34008] = 28280, 	[34009] = 28282, 	[34010] = 28281, 
	[42620] = 33165, 	[42974] = 33307, 	[44483] = 37332, 	[44494] = 37333, 
	[44524] = 37344, 	[44556] = 37331, 	[44575] = 44484, 	[44576] = 44494, 
	[44588] = 37340, 	[44590] = 37334, 	[44591] = 37347, 	[44595] = 44473, 
	[44596] = 37330, 	[44621] = 37339, 	[44625] = 44485, 	[44631] = 37349, 
	[45765] = 34872, 	[46578] = 35498, 	[46594] = 35500, 	[47051] = 35756, 
	[47672] = 44471, 	[47898] = 44472, 	[47899] = 44488, 	[47901] = 44491, 
	[59619] = 44496, 	[59621] = 44492, 	[59625] = 44495, 	[60691] = 44483, 
	[60692] = 44489, 	[60707] = 44486, 	[60714] = 44487, 	[60763] = 44490, 
	[60767] = 44498, 	[62256] = 44944, 	[62257] = 44945, 	[62948] = 45059, 
	[64441] = 46027, 	[64579] = 46348, 

	-------------------------------------------------------------------------------
	--Engineering
	-------------------------------------------------------------------------------
	[3928] = 4408, 		[3933] = 4409, 		[3939] = 13309,		[3940] = 4410, 
	[3944] = 4411, 		[3952] = 14639, 	[3954] = 4412, 		[3957] = 13308, 
	[3959] = 4413, 		[3960] = 4414, 		[3966] = 4415, 		[3968] = 4416, 
	[3969] = 13311, 	[3971] = 7742, 		[3972] = 4417, 		[3979] = 13310, 
	[8243] = 6672, 		[8339] = 6716, 		[9269] = 7560, 		[9273] = 7561, 
	[12587] = 10601, 	[12597] = 10602, 	[12607] = 10603, 	[12614] = 10604, 
	[12615] = 10605, 	[12616] = 10606, 	[12617] = 10607, 	[12620] = 10608, 
	[12624] = 10609, 	[15628] = 11828, 	[15633] = 11827, 	[19790] = 16041, 
	[19791] = 16042, 	[19792] = 16043, 	[19793] = 16044, 	[19794] = 16045, 
	[19795] = 16047, 	[19796] = 16048, 	[19799] = 16049, 	[19800] = 16051, 
	[19814] = 16046, 	[19815] = 16050, 	[19819] = 16052, 	[19825] = 16053, 
	[19830] = 16054, 	[19831] = 16055, 	[19833] = 16056, 	[21940] = 17720, 
	[22793] = 18290, 	[22795] = 18292, 	[22797] = 18291, 	[23066] = 18647, 
	[23067] = 18649, 	[23068] = 18648, 	[23069] = 18650, 	[23071] = 18651, 
	[23077] = 18652, 	[23078] = 18653, 	[23079] = 18655, 	[23080] = 18656, 
	[23081] = 18657, 	[23082] = 18658, 	[23096] = 18654, 	[23129] = 18661, 
	[23507] = 19027, 	[24356] = 20000, 	[24357] = 20001, 	[26416] = 21724, 
	[26417] = 21725, 	[26418] = 21726, 	[26420] = 21727, 	[26421] = 21728, 
	[26422] = 21729, 	[26423] = 21730, 	[26424] = 21731, 	[26425] = 21732, 
	[26426] = 21733, 	[26427] = 21734, 	[26428] = 21735, 	[26442] = 44919, 
	[26443] = 44918, 	[28327] = 22729, 	[30313] = 23799, 	[30314] = 23800, 
	[30315] = 23802, 	[30316] = 23803, 	[30317] = 23804, 	[30318] = 23805, 
	[30325] = 23806, 	[30329] = 23807, 	[30332] = 23808, 	[30334] = 23809, 
	[30337] = 23810, 	[30341] = 23811, 	[30344] = 23814, 	[30347] = 23815, 
	[30348] = 23816, 	[30349] = 23817, 	[30547] = 23874, 	[30548] = 23888, 
	[30551] = 35310, 	[30552] = 35311, 	[30556] = 23887, 	[32814] = 25887, 
	[39895] = 32381, 	[43676] = 33804, 	[44391] = 34114, 	[46106] = 35191, 
	[46107] = 35187, 	[46108] = 35189, 	[46109] = 35190, 	[46110] = 35192, 
	[46111] = 35186, 	[46112] = 35193, 	[46113] = 35194, 	[46114] = 35195, 
	[46115] = 35196, 	[46116] = 35197, 	[46697] = 35582,  [60866] = 44502, 	[60867] = 44503, 

	-------------------------------------------------------------------------------
	--Inscription
	-------------------------------------------------------------------------------

	-------------------------------------------------------------------------------
	--Jewelcrafting
	-------------------------------------------------------------------------------
	[25320] = 20856, 	[25323] = 20855, 	[25339] = 20854, 	[25610] = 20970, 
	[25612] = 20971, 	[25617] = 20973, 	[25618] = 20974, 	[25619] = 20975, 
	[25622] = 20976, 	[26873] = 21940, 	[26875] = 21941, 	[26878] = 21942, 
	[26881] = 21943, 	[26882] = 21944, 	[26887] = 21945, 	[26896] = 21947, 
	[26897] = 21948, 	[26900] = 21949, 	[26906] = 21952, 	[26909] = 21953, 
	[26910] = 21954, 	[26912] = 21955, 	[26914] = 21956, 	[26915] = 21957, 
	[28903] = 23130, 	[28905] = 23131, 	[28906] = 23133, 	[28907] = 23134, 
	[28910] = 23135, 	[28912] = 23136, 	[28914] = 23137, 	[28915] = 23138, 
	[28916] = 23140, 	[28917] = 23141, 	[28918] = 31359, 	[28924] = 23143, 
	[28927] = 23145, 	[28933] = 23146, 	[28936] = 23147, 
	[28938] = 23148, 	[28944] = 23149, 	[28947] = 23150, 	[28948] = 23151, 
	[28950] = 23152, 	[28953] = 23153, 	[28955] = 23154, 	[28957] = 23155, 
	[31053] = 24158, 	[31054] = 24159, 	[31055] = 24160, 	[31056] = 24161, 
	[31057] = 24162, 	[31058] = 24163, 	[31060] = 24164, 	[31061] = 24165, 
	[31062] = 24174, 	[31063] = 24175, 	[31064] = 24176, 	[31065] = 24177, 
	[31066] = 24178, 	[31067] = 24166, 	[31068] = 24167, 	[31070] = 24168, 
	[31071] = 24169, 	[31072] = 24170, 	[31076] = 24171, 	[31077] = 24172, 
	[31078] = 24173, 	[31079] = 24179, 	[31080] = 31358, 	[31081] = 24181, 
	[31082] = 24182, 	[31083] = 24183, 	[31084] = 24193, 	[31085] = 24194, 
	[31087] = 24195, 	[31088] = 35305, 	[31089] = 35306, 	[31090] = 24197, 
	[31091] = 24198, 	[31092] = 35304, 	[31094] = 24201, 	[31095] = 24202, 
	[31096] = 24203, 	[31097] = 24204, 	[31098] = 35307, 	[31099] = 24206, 
	[31100] = 24207, 	[31101] = 24208, 	[31102] = 24209, 	[31103] = 24210, 
	[31104] = 24211, 	[31105] = 24212, 	[31106] = 24213, 	[31107] = 24214, 
	[31108] = 24215, 	[31109] = 24216, 	[31110] = 24217, 	[31111] = 24218, 
	[31112] = 24219, 	[31113] = 24220, 	[31149] = 24200, 	[32866] = 25902, 
	[32867] = 25903, 	[32868] = 25905, 	[32869] = 25906, 	[32870] = 25904, 
	[32871] = 25907, 	[32872] = 25909, 	[32873] = 25908, 	[32874] = 25910, 
	[34069] = 28291, 	[34590] = 28596, 	[37855] = 30826, 	[38503] = 31401, 
	[38504] = 31402, 	[39451] = 31870, 	[39452] = 31875, 	[39455] = 31871, 
	[39458] = 31872, 	[39462] = 31877, 	[39463] = 31876, 	[39466] = 31873, 
	[39467] = 31874, 	[39470] = 31878, 	[39471] = 31879, 	[39705] = 35244, 
	[39706] = 35246, 	[39710] = 35250, 	[39711] = 35248, 	[39712] = 35245, 
	[39713] = 35249, 	[39714] = 35247, 	[39715] = 35263, 	[39716] = 35264, 
	[39717] = 35262, 	[39718] = 35265, 	[39719] = 35255, 	[39720] = 35260, 
	[39721] = 35259, 	[39722] = 35256, 	[39723] = 35261, 	[39724] = 35258, 
	[39725] = 35257, 	[39727] = 35243, 	[39728] = 35242, 	[39729] = 35238, 
	[39730] = 35240, 	[39731] = 35239, 	[39732] = 35241, 	[39733] = 35267, 
	[39734] = 35269, 	[39735] = 35268, 	[39736] = 35266, 	[39737] = 35270, 
	[39738] = 35271, 	[39739] = 35252, 	[39740] = 35254, 	[39741] = 35251, 
	[39742] = 35253, 	[39961] = 33622, 	[39963] = 32411, 	[42558] = 33305, 
	[42588] = 33155, 	[42589] = 33156, 	[42590] = 33157, 	[42591] = 33158, 
	[42592] = 33159, 	[42593] = 33160, 	[43493] = 33783, 	[44794] = 34689, 
	[46122] = 35198, 	[46123] = 35538, 	[46124] = 35200, 	[46125] = 35201, 
	[46126] = 35533, 	[46127] = 35203, 	[46403] = 35322, 	[46404] = 35323, 
	[46405] = 35325, 	[46597] = 35502, 	[46601] = 35505, 	[46775] = 35695, 
	[46776] = 35696, 	[46777] = 35697, 	[46778] = 35698, 	[46779] = 35699, 
	[46803] = 35708, 	[47053] = 35769, 	[47054] = 35766, 	[47055] = 35767, 
	[47056] = 35768, 	[48789] = 37504, 	[53830] = 41576, 	[53857] = 41559, 
	[53865] = 41575, 	[53869] = 41574, 	[53875] = 41566, 	[53877] = 41562, 
	[53879] = 41565, 	[53884] = 41563, 	[53885] = 41561, 	[53888] = 41564, 
	[53917] = 41567, 	[53919] = 41572, 	[53921] = 41568, 	[53924] = 41571, 
	[53929] = 41573, 	[53932] = 41570, 	[53933] = 41569, 	[53943] = 41560, 
	[53945] = 41577, 	[53946] = 41718, 	[53948] = 41719, 	[53949] = 41578, 
	[53950] = 41817, 	[53951] = 41790, 	[53952] = 42138, 	[53954] = 41581, 
	[53955] = 41728, 	[53957] = 41720, 	[53958] = 41580, 	[53959] = 41791, 
	[53960] = 41727, 	[53961] = 41579, 	[53962] = 41784, 	[53963] = 41747, 
	[53964] = 41785, 	[53965] = 41725, 	[53966] = 41783, 	[53967] = 41701, 
	[53968] = 41740, 	[53970] = 41796, 	[53971] = 41703, 	[53972] = 41820, 
	[53973] = 41702, 	[53974] = 41726, 	[53975] = 41789, 	[53976] = 41777, 
	[53977] = 41780, 	[53978] = 41734, 	[53979] = 41794, 	[53980] = 41582, 
	[53981] = 41733, 	[53982] = 41792, 	[53983] = 41689, 	[53984] = 41686, 
	[53985] = 41688, 	[53986] = 41730, 	[53987] = 41690, 	[53988] = 41721, 
	[53990] = 41732, 	[53991] = 41687, 	[53992] = 41779, 	[53993] = 41722, 
	[53994] = 41818, 	[53995] = 41795, 	[53996] = 41723, 	[53997] = 41698, 
	[53998] = 41697, 	[54000] = 41738, 	[54001] = 41693, 	[54002] = 41699, 
	[54003] = 41781, 	[54004] = 41782, 	[54005] = 41737, 	[54006] = 41694, 
	[54008] = 41724, 	[54009] = 41696, 	[54010] = 41739, 	[54011] = 41692, 
	[54012] = 41819, 	[54013] = 41736, 	[54014] = 41735, 	[54019] = 41793, 
	[54023] = 41778, 	[55384] = 41705, 	[55387] = 41743, 	[55388] = 41744, 
	[55389] = 41704, 	[55390] = 41786, 	[55392] = 41706, 	[55393] = 41742, 
	[55395] = 41787, 	[55396] = 41708, 	[55397] = 41798, 	[55398] = 41799, 
	[55400] = 41710, 	[55401] = 41797, 	[55403] = 41711, 	[55404] = 41709, 
	[55405] = 41788, 	[55407] = 41707, 	[56049] = 42298, 	[56052] = 42301, 
	[56053] = 42309, 	[56054] = 42299, 	[56055] = 42314, 	[56056] = 42302, 
	[56074] = 42300, 	[56076] = 42303, 	[56077] = 42304, 	[56079] = 42305, 
	[56081] = 42306, 	[56083] = 42307, 	[56084] = 42308, 	[56085] = 42310, 
	[56086] = 42311, 	[56087] = 42312, 	[56088] = 42313, 	[56089] = 42315, 
	[56496] = 42648, 	[56497] = 42649, 	[56498] = 42650, 	[56499] = 42651, 
	[56500] = 42652, 	[56501] = 42653, 	[58147] = 43317, 	[58148] = 43318, 
	[58149] = 43319, 	[58150] = 43320, 	[58492] = 43485, 	[58507] = 43497, 
	[58954] = 43597,   [66556] = 46937, [66447] =  46917 , [66429] =  46899,
	[66557] =  46938, [66430] =  46900, [66432] =  46902, [66433] =  46903,
 [66497] =  46924, [66561] =  46942, [66434] = 46904, [66498] =  46925, 
 [66499] =  46926, [66436] =  46906, [66500] =  46927, [66437] =  46907, 
 [66501] =  46928, [66565] =  46946, [66438] =  46908, [66502] = 46929,
 [66566] =  46947, [66439] =  46909, [66503] = 46930  , [66567] =  46948,
 [66440] = 46910, [66504] =  46931, [66441] =  46911, [66505] =  46932,
 [66569] =  46950, [66442] = 46912, [66506] = 46933, [66570] =  46951,
 [66443] =  46913, [66444] = 46914, [66572] = 46953, [66445] =  46915, 
 [66573] = 46956, [66446] =  46916, [66574] =  47007, [66575] = 47008,
 [66448] =  46918, [66576] =  47010, [66449] =  46919, [66577] =  47011, 
 [66450] = 46920, [66578] = 47012, [66451] =  46921, [66579] = 47015, 
 [66452] =  46922, [66580] =  47016, [66453] = 46923, [66581] =  47017,
 [66582] =  47018, [66583] = 47019, [66584] =  47020, [66586] =  47022, 
 [68253] =  49112, [66338] = 46897, [66571] =  46952, [66564] = 46945,
 [66562] =  46943, [66560] =  46941, [66558] =  46939, [66554] =  46935, 
 [66559] =  46940, [66585] =  47021, [66555] = 46936, [66587] =  47023, 
 [66431] =  46901, [66428] =  46898, [66435] = 46905, [66563] = 46944, 
 [66553] = 46934 , [66568] = 46949,

	-------------------------------------------------------------------------------
	--Leatherworking
	-------------------------------------------------------------------------------
	[2158] = 2406, 		[2163] = 2407, 		[2164] = 2408, 		[2169] = 2409, 
	[3762] = 4293, 		[3765] = 7360, 		[3767] = 4294, 		[3769] = 4296, 
	[3771] = 4297, 		[3772] = 7613, 		[3773] = 4299, 		[3775] = 4298, 
	[3777] = 4300, 		[3778] = 14635, 	[3779] = 4301, 		[4096] = 13287, 
	[4097] = 13288, 	[5244] = 5083, 		[6702] = 5786, 		[6703] = 5787, 
	[6704] = 5788, 		[6705] = 5789, 		[7133] = 5972, 		[7149] = 5973, 	
	[7153] = 5974, 		[7953] = 6474, 		[7954] = 6475, 		[7955] = 6476, 	
	[8322] = 6710, 		[9064] = 7288, 		[9070] = 7289, 		[9072] = 7290, 	
	[9146] = 7361, 		[9147] = 7362, 		[9148] = 7363, 		[9149] = 7364, 
	[9195] = 7449, 		[9197] = 7450, 		[9202] = 7451, 		[9207] = 7452, 	
	[9208] = 7453, 		[10490] = 8384, 	[10509] = 8385, 	[10516] = 8409, 	
	[10520] = 8386, 	[10525] = 8395, 	[10529] = 8403, 	[10531] = 8387, 	
	[10533] = 8397, 	[10542] = 8398, 	[10544] = 8404, 	[10546] = 8405, 
	[10554] = 8399, 	[10560] = 8389, 	[10562] = 8390, 	[10564] = 8400, 	
	[10566] = 8406, 	[10568] = 8401, 	[10570] = 8402, 	[10572] = 8407, 	
	[10574] = 8408, 	[19048] = 15724, 	[19049] = 15725, 	[19050] = 15726, 
	[19051] = 15727, 	[19052] = 15728, 	[19053] = 15729, 	[19054] = 15730, 
	[19055] = 15731, 	[19059] = 15732, 	[19060] = 15733, 	[19061] = 15734, 
	[19062] = 15735, 	[19063] = 15737, 	[19064] = 15738, 	[19065] = 15739, 
	[19066] = 15740, 	[19067] = 15741, 	[19068] = 20253, 	[19070] = 15743, 
	[19071] = 15744, 	[19072] = 15745, 	[19073] = 15746, 	[19074] = 15747, 
	[19075] = 15748, 	[19076] = 15749, 	[19077] = 15751, 	[19078] = 15752, 
	[19079] = 15753, 	[19080] = 20254, 	[19081] = 15755, 	[19082] = 15756, 
	[19083] = 15757, 	[19084] = 15758, 	[19085] = 15759, 	[19086] = 15760, 
	[19087] = 15761, 	[19088] = 15762, 	[19089] = 15763, 	[19090] = 15764, 
	[19091] = 15765, 	[19092] = 15768, 	[19093] = 15769, 	[19094] = 15770, 
	[19095] = 15771, 	[19097] = 15772, 	[19098] = 15773, 	[19100] = 15774, 
	[19101] = 15775, 	[19102] = 15776, 	[19103] = 15777, 	[19104] = 15779, 
	[19107] = 15781, 	[20853] = 17022, 	[20854] = 17023, 	[20855] = 17025, 
	[21943] = 17722, 	[22711] = 18239, 	[22727] = 18252, 	[22921] = 18514, 
	[22922] = 18515, 	[22923] = 18516, 	[22926] = 18517, 	[22927] = 18518, 
	[22928] = 18519, 	[23190] = 18731, 	[23399] = 18949, 	[23703] = 19326, 
	[23704] = 19327, 	[23705] = 19328, 	[23706] = 19329, 	[23707] = 19330, 
	[23708] = 19331, 	[23709] = 19332, 	[23710] = 19333, 	[24121] = 19769, 
	[24122] = 19770, 	[24123] = 19771, 	[24124] = 19772, 	[24125] = 19773, 
	[24703] = 20382, 	[24846] = 20506, 	[24847] = 20507, 	[24848] = 20508, 
	[24849] = 20509, 	[24850] = 20510, 	[24851] = 20511, 	[24940] = 20576, 
	[26279] = 21548, 	[28472] = 22771, 	[28473] = 22770, 	[28474] = 22769, 
	[32455] = 25720, 	[32457] = 25721, 	[32458] = 25722, 	[32461] = 25725, 
	[32482] = 25726, 	[32485] = 25728, 	[32487] = 25729, 	[32488] = 25731, 
	[32489] = 25730, 	[32490] = 25732, 	[32493] = 25733, 	[32494] = 25734, 
	[32495] = 25735, 	[32496] = 25736, 	[32497] = 25737, 	[32498] = 29213, 
	[32499] = 29214, 	[32500] = 29215, 	[32501] = 29217, 	[32502] = 29219, 
	[32503] = 29218, 	[35520] = 29669, 	[35521] = 29672, 	[35522] = 29673, 
	[35523] = 29674, 	[35524] = 29675, 	[35525] = 29677, 	[35526] = 29682, 
	[35527] = 29684, 	[35528] = 29691, 	[35529] = 29689, 	[35530] = 30444, 
	[35531] = 29693, 	[35532] = 29698, 	[35533] = 29700, 	[35534] = 29701, 
	[35535] = 29702, 	[35536] = 29703, 	[35537] = 29704, 	[35538] = 29713, 
	[35539] = 34175, 	[35543] = 29717, 	[35544] = 34173, 	[35549] = 31361, 
	[35554] = 31362, 	[35555] = 29720, 	[35557] = 29721, 	[35558] = 29723, 
	[35559] = 35302, 	[35560] = 29725, 	[35561] = 29726, 	[35562] = 35303, 
	[35563] = 29728, 	[35564] = 29729, 	[35567] = 29730, 	[35568] = 35300, 
	[35572] = 29732, 	[35573] = 35301, 	[35574] = 29734, 	[36349] = 30301, 
	[36351] = 30302, 	[36352] = 30303, 	[36353] = 30304, 	[36355] = 30305, 
	[36357] = 30306, 	[36358] = 30307, 	[36359] = 30308, 	[39997] = 32429, 
	[40001] = 32431, 	[40002] = 32432, 	[40003] = 32433, 	[40004] = 32434, 
	[40005] = 32435, 	[40006] = 32436, 	[41156] = 32744, 	[41157] = 35523, 
	[41158] = 35527, 	[41160] = 35528, 	[41161] = 35517, 	[41162] = 35524, 
	[41163] = 35520, 	[41164] = 35521, 	[42546] = 33124, 	[42731] = 33205, 
	[44359] = 34200, 	[44768] = 34218, 	[44953] = 34262, 	[45117] = 34491, 
	[46132] = 35546, 	[46133] = 35541, 	[46134] = 35214, 	[46135] = 35215, 
	[46136] = 35216, 	[46137] = 35217, 	[46138] = 35218, 	[46139] = 35549, 
	[50970] = 44509, 	[50971] = 44510, 	[52733] = 32430, 	[57683] = 43097, 
	[57692] = 44559, 	[57694] = 44560, 	[57696] = 44561, 	[57699] = 44562, 
	[57701] = 44563, 	[60645] = 44511, 	[60647] = 44512, 	[60697] = 44513, 
	[60702] = 44514, 	[60703] = 44515, 	[60704] = 44516, 	[60705] = 44517, 
	[60706] = 44518, 	[60711] = 44519, 	[60712] = 44520, 	[60715] = 44521, 
	[60716] = 44522, 	[60718] = 44523, 	[60720] = 44524, 	[60721] = 44525, 
	[60723] = 44526, 	[60725] = 44527, 	[60727] = 44528, 	[60728] = 44530, 
	[60729] = 44531, 	[60730] = 44532, 	[60731] = 44533, 	[60732] = 44534, 
	[60734] = 44535, 	[60735] = 44536, 	[60737] = 44537, 	[60743] = 44538, 
	[60746] = 44539, 	[60747] = 44540, 	[60748] = 44541, 	[60749] = 44542, 
	[60750] = 44543, 	[60751] = 44544, 	[60752] = 44545, 	[60754] = 44546, 
	[60755] = 44547, 	[60756] = 44548, 	[60757] = 44549, 	[60758] = 44550, 
	[60759] = 44551, 	[60760] = 44552, 	[60761] = 44553, 	[60996] = 44584, 
	[60997] = 44585, 	[60998] = 44586, 	[60999] = 44587, 	[61000] = 44588, 
	[61002] = 44589, 	[62176] = 44932, 	[62177] = 44933, 	[63194] = 45094, 
	[63195] = 45095, 	[63196] = 45096, 	[63197] = 45097, 	[63198] = 45098, 
	[63199] = 45099, 	[63200] = 45100, 	[63201] = 45101, 

	-------------------------------------------------------------------------------
	--Smelting
	-------------------------------------------------------------------------------
	[22967] = 44956, 	[46353] = 35273, 

	-------------------------------------------------------------------------------
	--Tailoring
	-------------------------------------------------------------------------------
	[2389] = 2598, 		[2403] = 2601, 		[3758] = 4292, 		[3844] = 4346, 	
	[3847] = 4345, 		[3849] = 4347, 		[3851] = 4349, 		[3854] = 7114, 	
	[3856] = 4350, 		[3857] = 14630, 	[3858] = 4351, 		[3860] = 4352, 	
	[3862] = 4355, 		[3863] = 4353, 		[3864] = 4356, 		[3868] = 4348, 	
	[3869] = 14627, 	[3870] = 6401, 		[3872] = 4354, 		[3873] = 10728, 	
	[6686] = 5771, 		[6688] = 5772, 		[6692] = 5773, 		[6693] = 5774, 	
	[6695] = 5775, 		[7629] = 6271, 		[7630] = 6270, 		[7633] = 6272, 	
	[7639] = 6274, 		[7643] = 6275, 		[7892] = 6390, 		[7893] = 6391, 	
	[8780] = 7092, 		[8782] = 7091, 		[8784] = 7090, 		[8786] = 7089, 	
	[8789] = 7087, 		[8793] = 7084, 		[8795] = 7085, 		[8797] = 7086, 	
	[8802] = 7088, 		[12047] = 10316, 	[12056] = 10300, 	[12059] = 10301, 
	[12060] = 10302, 	[12064] = 10311, 	[12066] = 10312, 	[12075] = 10314, 
	[12078] = 10315, 	[12080] = 10317, 	[12081] = 10318, 	[12084] = 10320, 
	[12085] = 10321, 	[12086] = 10463, 	[12089] = 10323, 	[12091] = 10325, 
	[12093] = 10326, 	[18403] = 14466, 	[18404] = 14467, 	[18405] = 14468, 
	[18406] = 14469, 	[18407] = 14470, 	[18408] = 14471, 	[18409] = 14472, 
	[18410] = 14473, 	[18411] = 14474, 	[18412] = 14476, 	[18413] = 14477, 
	[18414] = 14478, 	[18415] = 14479, 	[18416] = 14480, 	[18417] = 14481, 
	[18418] = 14482, 	[18419] = 14483, 	[18420] = 14484, 	[18421] = 14485, 
	[18422] = 14486, 	[18423] = 14488, 	[18424] = 14489, 	[18434] = 14490, 
	[18436] = 14493, 	[18437] = 14492, 	[18438] = 14491, 	[18439] = 14494, 
	[18440] = 14497, 	[18441] = 14495, 	[18442] = 14496, 	[18444] = 14498, 
	[18445] = 14499, 	[18446] = 14500, 	[18447] = 14501, 	[18448] = 14507, 
	[18449] = 14504, 	[18450] = 14505, 	[18451] = 14506, 	[18452] = 14509, 
	[18453] = 14508, 	[18454] = 14511, 	[18455] = 14510, 	[18456] = 14512, 
	[18457] = 14513, 	[18458] = 14514, 	[18560] = 14526, 	[20848] = 17017, 
	[20849] = 17018, 	[21945] = 17724, 	[22759] = 18265, 	[22866] = 18414, 
	[22867] = 18415, 	[22868] = 18416, 	[22869] = 18417, 	[22870] = 18418, 
	[22902] = 18487, 	[23662] = 19215, 	[23663] = 19218, 	[23664] = 19216, 
	[23665] = 19217, 	[23666] = 19219, 	[23667] = 19220, 	[24091] = 19764, 
	[24092] = 19765, 	[24093] = 19766, 	[24901] = 20546, 	[24902] = 20548, 
	[24903] = 20547, 	[26085] = 21358, 	[26087] = 21371, 	[26403] = 44916, 
	[26407] = 44917, 	[26747] = 21892, 	[26749] = 21893, 	[26750] = 21894, 
	[26751] = 21895, 	[26752] = 21908, 	[26753] = 21909, 	[26754] = 21910, 
	[26755] = 21911, 	[26756] = 21912, 	[26757] = 21914, 	[26758] = 21913, 
	[26759] = 21915, 	[26760] = 21916, 	[26761] = 21918, 	[26762] = 21917, 
	[26763] = 21919, 	[26773] = 21896, 	[26774] = 21897, 	[26775] = 21898, 
	[26776] = 21899, 	[26777] = 21900, 	[26778] = 21901, 	[26779] = 21902, 
	[26780] = 21903, 	[26781] = 21904, 	[26782] = 21905, 	[26783] = 21906, 
	[26784] = 21907, 	[27658] = 22307, 	[27659] = 22308, 	[27660] = 22309, 
	[27724] = 22310, 	[27725] = 22312, 	[28210] = 22683, 	[28480] = 22774, 
	[28481] = 22773, 	[28482] = 22772, 	[31373] = 24316, 	[31430] = 24292, 
	[31431] = 24293, 	[31432] = 24294, 	[31433] = 24295, 	[31434] = 35308, 
	[31435] = 24297, 	[31437] = 24298, 	[31438] = 24299, 	[31440] = 24300, 
	[31441] = 24301, 	[31442] = 35309, 	[31443] = 24303, 	[31444] = 24304, 
	[31448] = 24305, 	[31449] = 24306, 	[31450] = 24307, 	[31451] = 24308, 
	[31452] = 24309, 	[31453] = 24310, 	[31454] = 24311, 	[31455] = 24312, 
	[31456] = 24313, 	[31459] = 24314, 	[36315] = 30280, 	[36316] = 30281, 
	[36317] = 30282, 	[36318] = 30283, 	[36686] = 30483, 	[37873] = 30833, 
	[37882] = 30842, 	[37883] = 30843, 	[37884] = 30844, 	[40020] = 32437, 
	[40021] = 32438, 	[40023] = 32439, 	[40024] = 32440, 	[40060] = 32447, 
	[41205] = 35518, 	[41206] = 32755, 	[41207] = 32752, 	[41208] = 32753, 
	[44950] = 34261, 	[44958] = 34319, 	[46128] = 35204, 	[46129] = 35205, 
	[46130] = 35206, 	[46131] = 35207, 	[49677] = 37915, 	[50194] = 38229, 
	[50644] = 38327, 	[50647] = 38328, 	[55993] = 42172, 	[55994] = 42173, 
	[55996] = 42175, 	[55997] = 42177, 	[55998] = 42176, 	[55999] = 42178, 
	[56004] = 42183, 	[56005] = 42184, 	[56006] = 42185, 	[56009] = 42187, 
	[56011] = 42188, 	[63924] = 45774, 
}

-- create the reverse table, which is what we actually need
Altoholic.RecipeDB = {}
for k, v in pairs(SPELL_ITEM) do
	Altoholic.RecipeDB[v] = k
end

-- release memory
wipe(SPELL_ITEM)
SPELL_ITEM = nil
